/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater.getdown;

import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.Downloader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.StreamingUrl;
import org.tinymediamanager.scraper.http.Url;

public class TmmGetdownDownloader
extends Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmGetdownDownloader.class);

    public TmmGetdownDownloader() {
        super(null);
    }

    public boolean download(Collection<Resource> resources, int maxConcurrent) {
        for (Resource rsrc : resources) {
            File parent = new File(rsrc.getLocalNew().getParent());
            if (parent.exists() || parent.mkdirs()) continue;
            LOGGER.debug("Failed to create target directory for resource '{}'", (Object)rsrc);
        }
        super.download(resources, maxConcurrent);
        LOGGER.debug("Finished downloading with state '{}'", (Object)this._state);
        return this._state == Downloader.State.COMPLETE;
    }

    protected void downloadProgress(int percent, long remaining) {
        if (percent == 100) {
            this._state = Downloader.State.COMPLETE;
        }
    }

    protected long checkSize(Resource rsrc) throws IOException {
        long l;
        block8: {
            Url url = new Url(rsrc.getRemote().toString());
            InputStream ignored = url.getInputStream(true);
            try {
                this.checkConnectOK(url, "Unable to check up-to-date for " + rsrc.getRemote());
                l = url.getContentLength();
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            ignored.close();
        }
        return l;
    }

    protected void download(Resource rsrc) throws IOException {
        StreamingUrl url = new StreamingUrl(rsrc.getRemote().toString());
        try (InputStream in = url.getInputStream();
             FileOutputStream out = new FileOutputStream(rsrc.getLocalNew());){
            int read;
            this.checkConnectOK(url, "Unable to download resource " + rsrc.getRemote());
            long actualSize = url.getContentLength();
            LOGGER.debug("Downloading resource [url={}, size={}]", (Object)rsrc.getRemote(), (Object)actualSize);
            long currentSize = 0L;
            byte[] buffer = new byte[16384];
            while ((read = in.read(buffer)) != -1) {
                if (this._state == Downloader.State.ABORTED) {
                    break;
                }
                out.write(buffer, 0, read);
                this.reportProgress(rsrc, currentSize += (long)read, actualSize);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        catch (Exception e) {
            this._state = Downloader.State.FAILED;
            this.downloadFailed(rsrc, e);
        }
    }

    private void checkConnectOK(Url url, String errpre) throws IOException {
        int code = url.getStatusCode();
        switch (code) {
            case 200: {
                return;
            }
            case 305: 
            case 403: {
                break;
            }
        }
        throw new IOException(errpre + " [code=" + code + "]");
    }

    protected void downloadFailed(Resource rsrc, Exception cause) {
        LOGGER.error("Could not download resource '{}' - {}", (Object)rsrc.getRemote(), (Object)cause.getMessage());
    }
}

