/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.datepicker;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmDateFormat;

class DateTextField
extends JFormattedTextField
implements CaretListener,
FocusListener,
ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTextField.class);
    private Date date;
    private SimpleDateFormat dateFormatter;
    private String datePattern;
    private String maskPattern;
    private Color positiveColor;
    private Color negativeColor;
    private int hours;
    private int minutes;
    private int seconds;
    private int millis;
    private Calendar calendar;

    public DateTextField() {
        this((String)null);
    }

    public DateTextField(String datePattern) {
        this.setDateFormatString(datePattern);
        this.maskPattern = this.createMaskFromDatePattern(this.datePattern);
        this.setColumns(this.datePattern.length());
        this.setToolTipText(this.datePattern);
        this.addCaretListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.positiveColor = new Color(0, 150, 0);
        this.negativeColor = Color.RED;
        this.calendar = Calendar.getInstance();
    }

    public Date getDate() {
        try {
            this.calendar.setTime(this.dateFormatter.parse(this.getText()));
            this.calendar.set(11, this.hours);
            this.calendar.set(12, this.minutes);
            this.calendar.set(13, this.seconds);
            this.calendar.set(14, this.millis);
            this.date = this.calendar.getTime();
        }
        catch (ParseException e) {
            this.date = null;
        }
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, true);
    }

    private void setDate(Date date, boolean firePropertyChange) {
        Date oldDate = this.date;
        this.date = date;
        if (date == null) {
            this.setText("");
        } else {
            this.calendar.setTime(date);
            this.hours = this.calendar.get(11);
            this.minutes = this.calendar.get(12);
            this.seconds = this.calendar.get(13);
            this.millis = this.calendar.get(14);
            String formattedDate = this.dateFormatter.format(date);
            try {
                this.setText(formattedDate);
            }
            catch (RuntimeException e) {
                LOGGER.debug("Could not set text", (Throwable)e);
            }
        }
        this.setForeground(UIManager.getColor("FormattedTextField.foreground"));
        if (firePropertyChange) {
            this.firePropertyChange("date", oldDate, date);
        }
    }

    private void setDateFormatString(String dateFormatString) {
        try {
            this.dateFormatter = new SimpleDateFormat();
            this.dateFormatter.applyPattern(dateFormatString);
        }
        catch (RuntimeException e) {
            this.dateFormatter = (SimpleDateFormat)TmmDateFormat.getDateFormat();
            this.dateFormatter.setLenient(false);
        }
        this.datePattern = this.dateFormatter.toPattern();
        this.setToolTipText(this.datePattern);
        this.setDate(this.date, false);
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        String text = this.getText().strip();
        String emptyMask = this.maskPattern.replace('#', ' ');
        if (text.length() == 0 || text.equals(emptyMask)) {
            this.setForeground(UIManager.getColor("FormattedTextField.foreground"));
            return;
        }
        try {
            this.dateFormatter.parse(this.getText());
            this.setForeground(this.positiveColor);
        }
        catch (Exception e) {
            this.setForeground(this.negativeColor);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.checkText();
    }

    private void checkText() {
        try {
            Date date = this.dateFormatter.parse(this.getText());
            this.setDate(date, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private String createMaskFromDatePattern(String datePattern) {
        String symbols = "GyMdkHmsSEDFwWahKzZ";
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < datePattern.length(); ++i) {
            char ch = datePattern.charAt(i);
            boolean symbolFound = false;
            for (int n = 0; n < symbols.length(); ++n) {
                if (symbols.charAt(n) != ch) continue;
                mask.append("#");
                symbolFound = true;
                break;
            }
            if (symbolFound) continue;
            mask.append(ch);
        }
        return mask.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            super.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }
}

