/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.util.List;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToKodiConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowEpisodeToEmbyConnector
extends TvShowEpisodeToKodiConnector {
    public TvShowEpisodeToEmbyConnector(List<TvShowEpisode> episodes) {
        super(episodes);
    }

    @Override
    protected void addOwnTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        super.addOwnTags(episode, parser);
        if (episode.isMultiEpisode()) {
            TvShowEpisode highest = new TvShowEpisode();
            for (TvShowEpisode tvShowEpisode : this.episodes) {
                if (tvShowEpisode.getSeason() > highest.getSeason()) {
                    highest = tvShowEpisode;
                }
                if (tvShowEpisode.getSeason() != highest.getSeason() || tvShowEpisode.getEpisode() <= highest.getEpisode()) continue;
                highest = tvShowEpisode;
            }
            this.addEpisodeNumberEnd(highest, parser);
        }
    }

    protected void addEpisodeNumberEnd(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element episodenumberend = this.document.createElement("episodenumberend");
        episodenumberend.setTextContent(String.valueOf(episode.getEpisode()));
        this.root.appendChild(episodenumberend);
    }

    @Override
    protected void addCredits(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
    }

    @Override
    protected void addDirectors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
    }

    @Override
    protected void addActors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        super.addActors(episode, parser);
        super.addCredits(episode, parser);
        super.addDirectors(episode, parser);
    }
}

