/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.LoggerContext;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.SystemUtils;
import org.h2.mvstore.MVStoreException;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.cli.TinyMediaManagerCLI;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettingsDefaults;
import org.tinymediamanager.core.movie.MovieUpgradeTasks;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.core.tvshow.TvShowUpgradeTasks;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.license.License;
import org.tinymediamanager.logging.Log4jBackstop;
import org.tinymediamanager.logging.TmmLoggingUtils;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.thirdparty.ExternalTools;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.thirdparty.yt.YtDlp;
import org.tinymediamanager.thirdparty.yt.YtDownloader;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmTaskbar;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.dialogs.AboutDialog;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.dialogs.TmmSplashScreen;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public final class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);
    private TmmSplashScreen splashScreen = null;
    private final boolean headless = GraphicsEnvironment.isHeadless();
    private boolean newVersion = false;

    private TinyMediaManager() {
    }

    private void launch(String[] args) {
        LOGGER.trace("entered launch");
        Path license = Paths.get(Globals.DATA_FOLDER, "tmm.lic");
        if (Files.exists(license, new LinkOption[0])) {
            try {
                License.getInstance().setLicenseCode(Utils.readFileToString(license));
            }
            catch (Exception e) {
                LOGGER.debug("unable to decode license file - {}", (Object)e.getMessage());
            }
        }
        Locale.setDefault(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()));
        TmmResourceBundle.clearCache();
        this.newVersion = !Settings.getInstance().isCurrentVersion();
        this.printLogHeader();
        if (!this.headless) {
            LOGGER.trace("entered GUI mode");
            SwingUtilities.invokeLater(() -> {
                TmmUIHelper.setLookAndFeel();
                try {
                    LOGGER.trace("loading splash");
                    this.splashScreen = new TmmSplashScreen();
                }
                catch (Exception e) {
                    LOGGER.error("Could not initialize splash - '{}'", (Object)e.getMessage());
                }
                TmmTaskbar.setImage(new LogoCircle(512).getImage());
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        LOGGER.trace("entered doInBackground");
                        try {
                            Thread.currentThread().setName("main");
                            SwingUtilities.invokeLater(() -> TinyMediaManager.this.splashScreen.setVisible(true));
                            TmmUILogCollector.init();
                            TinyMediaManager.this.startup();
                            TinyMediaManager.this.updateProgress("splash.ui", 90);
                            SwingUtilities.invokeLater(() -> {
                                LocalDate validUntil;
                                TmmThreadPool task;
                                boolean wizardRun = false;
                                if (Settings.getInstance().isNewConfig()) {
                                    LOGGER.trace("show wizard");
                                    TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                                    wizard.setLocationRelativeTo(null);
                                    wizard.setVisible(true);
                                    wizardRun = true;
                                }
                                TinyMediaManager.this.systemUiInit();
                                MainWindow window = MainWindow.getInstance();
                                TinyMediaManager.this.updateProgress("finished starting :)", 100);
                                TmmLoggingUtils.stopStartupAppender();
                                TinyMediaManager.this.splashScreen.setVisible(false);
                                TmmUILayoutStore.getInstance().loadSettings(window);
                                window.setVisible(true);
                                LOGGER.info("UI loaded");
                                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                    LOGGER.info("received shutdown signal");
                                    if (!GraphicsEnvironment.isHeadless()) {
                                        MainWindow.getInstance().saveWindowLayout();
                                    }
                                    TinyMediaManager.shutdown();
                                    TinyMediaManager.shutdownLogger();
                                }));
                                if (wizardRun) {
                                    if (!MovieModuleManager.getInstance().getSettings().getMovieDataSource().isEmpty()) {
                                        task = new MovieUpdateDatasourceTask();
                                        TmmTaskManager.getInstance().addMainTask(task);
                                    }
                                    if (!TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().isEmpty()) {
                                        task = new TvShowUpdateDatasourceTask();
                                        TmmTaskManager.getInstance().addMainTask(task);
                                    }
                                }
                                if (TinyMediaManager.this.newVersion && !ReleaseInfo.getVersion().equals(UpgradeTasks.getOldVersion())) {
                                    SwingUtilities.invokeLater(WhatsNewDialog::showChangelog);
                                }
                                if (License.getInstance().isValidLicense() && (validUntil = License.getInstance().validUntil()) != null && validUntil.minusDays(7L).isBefore(LocalDate.now())) {
                                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(window, TmmResourceBundle.getString("tmm.renewlicense").replace("{}", TmmDateFormat.getDateFormat().format(Date.valueOf(validUntil)))));
                                }
                                if (MovieModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                    task = new MovieUpdateDatasourceTask();
                                    TmmTaskManager.getInstance().addMainTask(task);
                                }
                                if (TvShowModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                    task = new TvShowUpdateDatasourceTask();
                                    TmmTaskManager.getInstance().addMainTask(task);
                                }
                            });
                        }
                        catch (IllegalStateException | MVStoreException e) {
                            LOGGER.error("MVStoreException", e);
                            if (e.getMessage().contains("file is locked")) {
                                JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.nostart") + "\n" + TmmResourceBundle.getString("tmm.nostart.instancerunning"), TmmResourceBundle.getString("tmm.nostart"), 0, new LogoCircle());
                            }
                            TinyMediaManager.shutdownLogger();
                            System.exit(1);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while starting tmm", (Throwable)e);
                            MessageDialog.showExceptionWindow(e);
                            TinyMediaManager.shutdownLogger();
                            System.exit(1);
                        }
                        return null;
                    }
                };
                worker.execute();
            });
        } else {
            LOGGER.trace("entered CLI mode");
            Thread.currentThread().setName("headless");
            LOGGER.debug("starting without GUI...");
            try {
                this.startup();
            }
            catch (IllegalStateException | MVStoreException e) {
                LOGGER.error("MVStoreException", e);
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            catch (Exception e) {
                LOGGER.error("Exception while starting tmm", (Throwable)e);
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            TinyMediaManager.setLogLevels();
            TinyMediaManagerCLI.start(args);
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            LOGGER.info("bye bye");
            try {
                TinyMediaManager.shutdown();
                TinyMediaManager.shutdownLogger();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
            }
            System.exit(0);
        }
    }

    private void systemUiInit() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(e -> {
                AboutDialog about = new AboutDialog();
                ((Dialog)about).setVisible(true);
            });
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(e -> {
                JDialog settings = SettingsDialog.getInstance();
                settings.setVisible(true);
            });
        }
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler((e, response) -> {
                TinyMediaManager.shutdown();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            });
        }
    }

    public static String[] generateLogHeader() {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("=======================================================");
        lines.add("=== tinyMediaManager (c) 2012 - 2025 Manuel Laggner ===");
        lines.add("=======================================================");
        lines.add("tmm.version      : " + ReleaseInfo.getRealVersion());
        if (!ReleaseInfo.isGitBuild()) {
            lines.add("tmm.build        : " + ReleaseInfo.getRealBuildDate());
        }
        if (Globals.isDocker()) {
            lines.add("tmm.docker       : true");
        }
        lines.add("tmm.home         : " + Path.of("", new String[0]).toAbsolutePath().toString());
        lines.add("tmm.datafolder   : " + Globals.DATA_FOLDER);
        lines.add("tmm.cachefolder  : " + Globals.CACHE_FOLDER);
        lines.add("tmm.backupfolder : " + Globals.BACKUP_FOLDER);
        lines.add("tmm.logfolder    : " + Globals.LOG_FOLDER);
        lines.add("os.name          : " + System.getProperty("os.name"));
        lines.add("os.version       : " + System.getProperty("os.version"));
        lines.add("os.arch          : " + System.getProperty("os.arch"));
        lines.add("java.version     : " + System.getProperty("java.version"));
        lines.add("java.maxMem      : " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB");
        if (Globals.isRunningJavaWebStart()) {
            lines.add("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            lines.add("java.webswing    : true");
        }
        byte[] bArray = new byte[]{119};
        lines.add("current encoding : " + System.getProperty("file.encoding") + " | " + new InputStreamReader(new ByteArrayInputStream(bArray)).getEncoding() + " | " + Charset.defaultCharset());
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        lines.add("JVM parameters   : " + String.join((CharSequence)" ", runtimeMXBean.getInputArguments()));
        lines.add("System language  : " + System.getProperty("user.language") + "_" + System.getProperty("user.country"));
        lines.add("GUI language     : " + Locale.getDefault().toLanguageTag());
        lines.add("=====================================================");
        return (String[])lines.toArray(String[]::new);
    }

    private void printLogHeader() {
        for (String line : TinyMediaManager.generateLogHeader()) {
            LOGGER.info(line);
        }
        LOGGER.info("starting tinyMediaManager");
    }

    private void startup() throws Exception {
        this.doPreStartupTasks();
        org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(Level.SEVERE);
        this.doUpgradeTasks();
        this.loadInternals();
        this.loadModules();
        this.loadPlugins();
        this.loadServices();
        this.doPostStartupTasks();
    }

    private void doUpgradeTasks() {
        LOGGER.trace("entered doUpgradeTasks");
        UpgradeTasks.setOldVersion();
        if (this.newVersion) {
            LOGGER.info("Upgrade from '{}' to '{}'", (Object)UpgradeTasks.getOldVersion(), (Object)ReleaseInfo.getVersion());
            this.updateProgress("splash.upgrade", 10);
            UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading();
            Settings.getInstance().setCurrentVersion();
            Settings.getInstance().saveSettings();
        }
        if (this.newVersion || TmmUIHelper.shouldCheckForUpdate()) {
            TmmTaskManager.getInstance().addDownloadTask(new ExternalTools.ExternalToolsUpgradeTask("ffmpeg"));
            TmmTaskManager.getInstance().addDownloadTask(new ExternalTools.ExternalToolsUpgradeTask("yt-dlp"));
        }
    }

    private void loadInternals() {
        LOGGER.trace("entered loadInternals");
        this.updateProgress("splash.internals", 20);
        TmmOsUtils.loadNativeLibs();
        if (License.getInstance().validUntil() != null) {
            LOGGER.debug("{}", (Object)License.getInstance().sig());
            LOGGER.debug("{}", (Object)License.getInstance().dat());
        }
        MediaGenres.init();
        LanguageUtils.init();
        ImageCache.init();
        MessageManager.init();
        YtDlp.init();
        YtDownloader.init();
        TmmHttpServer.init();
        if (Settings.getInstance().isEnableHttpServer()) {
            try {
                TmmHttpServer.getInstance();
            }
            catch (Exception e) {
                LOGGER.error("Could not start web server - '{}'", (Object)e.getMessage());
            }
        }
    }

    private void loadModules() throws Exception {
        LOGGER.trace("entered loadModules");
        this.updateProgress("splash.movie", 30);
        TmmModuleManager.getInstance().startUp();
        TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
        TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
        this.updateProgress("splash.tvshow", 50);
        TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
        TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
    }

    private void loadPlugins() {
        LOGGER.trace("entered loadPlugins");
        this.updateProgress("splash.plugins", 60);
        MediaProviders.loadMediaProviders();
        if (MovieModuleManager.getInstance().getSettings().isNewConfig()) {
            MovieSettingsDefaults.setDefaultScrapers();
        }
        if (TvShowModuleManager.getInstance().getSettings().isNewConfig()) {
            TvShowSettingsDefaults.setDefaultScrapers();
        }
    }

    private void loadServices() {
        LOGGER.trace("entered loadServices");
        this.updateProgress("splash.services", 70);
        Upnp.init();
        try {
            Upnp.getInstance().updateConfiguration(Settings.getInstance().isUpnpShareLibrary(), Settings.getInstance().isUpnpRemotePlay(), Settings.getInstance().getUpnpPort());
        }
        catch (Exception e) {
            LOGGER.error("Could not start UPnP server - '{}'", (Object)e.getMessage());
        }
        if (!Settings.getInstance().getKodiHost().isBlank()) {
            try {
                KodiRPC.getInstance().connect();
            }
            catch (Exception e) {
                LOGGER.error("Could not start KodiRPC - '{}'", (Object)e.getMessage());
            }
        }
    }

    private void doPreStartupTasks() {
        LOGGER.trace("entered doPreStartupTasks");
        Utils.cleanOldLogs();
        Path db = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
        Utils.createBackupFile(db);
        Utils.deleteOldBackupFile(db, 5);
        if (SystemUtils.IS_OS_LINUX && !TmmOsUtils.existsDesktopFileForLinux()) {
            Path desktopFile = Paths.get(System.getProperty("user.home"), ".local", "share", "applications", "tinyMediaManager.desktop").toAbsolutePath();
            if (Files.isWritable(desktopFile.getParent())) {
                TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
            } else {
                TmmOsUtils.createDesktopFileForLinux(new File("tinyMediaManager.desktop"));
            }
        }
    }

    private void doPostStartupTasks() {
        LOGGER.trace("entered doPostStartupTasks");
        this.updateProgress("splash.upgrade2", 80);
        MovieUpgradeTasks movieUpgradeTasks = new MovieUpgradeTasks();
        movieUpgradeTasks.performSettingsUpgrades();
        movieUpgradeTasks.performDbUpgrades();
        TvShowUpgradeTasks tvShowUpgradeTasks = new TvShowUpgradeTasks();
        tvShowUpgradeTasks.performSettingsUpgrades();
        tvShowUpgradeTasks.performDbUpgrades();
    }

    private void updateProgress(String text, int progress) {
        LOGGER.trace("{} - {}%", (Object)text, (Object)progress);
        if (this.splashScreen == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.splashScreen.setProgress(progress, text);
            Container container = this.splashScreen.getContentPane();
            if (container instanceof JComponent) {
                JComponent content = (JComponent)container;
                content.paintImmediately(content.getBounds());
            }
        });
    }

    public static void main(String[] args) {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
        try {
            License.getInstance().init522();
        }
        catch (Exception e) {
            LOGGER.error("Could not initialize license module!");
            LOGGER.debug(e.getMessage());
        }
        ReleaseInfo.init();
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: {}", (Object)Arrays.toString(args));
            if (!TinyMediaManagerCLI.checkArgs(args)) {
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCLI.printHelp();
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            TinyMediaManager.setLogLevels();
        }
        TinyMediaManager tinyMediaManager = new TinyMediaManager();
        tinyMediaManager.launch(args);
    }

    public static void shutdown() {
        LOGGER.info("Shutting down tinyMediaManager");
        try {
            TmmProperties.getInstance().writeProperties();
            Upnp.getInstance().shutdown();
            TmmTaskManager.getInstance().shutdown();
            TmmModuleManager.getInstance().saveSettings();
            TmmTaskManager.getInstance().shutdownNow();
            TmmModuleManager.getInstance().shutDown();
        }
        catch (Exception ex) {
            LOGGER.warn("Problem in shutdown", (Throwable)ex);
        }
    }

    public static void shutdownLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    public static void setLogLevels() {
        TmmLoggingUtils.setConsoleLogLevel();
        TmmLoggingUtils.setLogLevel("org.tinymediamanager.thirdparty.upnp", "tmm.logging.jupnp");
    }
}

