/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader.request;

import com.github.kiulian.downloader.base64.Base64Encoder;
import com.github.kiulian.downloader.downloader.request.Request;
import com.github.kiulian.downloader.model.search.SearchResult;
import com.github.kiulian.downloader.model.search.field.DurationField;
import com.github.kiulian.downloader.model.search.field.FeatureField;
import com.github.kiulian.downloader.model.search.field.FormatField;
import com.github.kiulian.downloader.model.search.field.SearchField;
import com.github.kiulian.downloader.model.search.field.SortField;
import com.github.kiulian.downloader.model.search.field.TypeField;
import com.github.kiulian.downloader.model.search.field.UploadDateField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestSearchResult
extends Request<RequestSearchResult, SearchResult> {
    private static final byte[] FORCED_DATA = new byte[]{66, 2, 8, 1};
    private final String query;
    private boolean forceExactQuery;
    private Map<Integer, SearchField> filterFields = new HashMap<Integer, SearchField>();
    private SortField sortField;

    public RequestSearchResult(String string) {
        this.query = string;
    }

    public String encodeParameters() {
        Object object;
        if (this.sortField == null && this.filterFields.isEmpty() && !this.forceExactQuery) {
            return null;
        }
        int n = 0;
        ArrayList<SearchField> arrayList = null;
        if (!this.filterFields.isEmpty()) {
            arrayList = new ArrayList<SearchField>(this.filterFields.values());
            arrayList.sort((searchField, searchField2) -> searchField.category() - searchField2.category());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (SearchField)iterator.next();
                n += object.length();
            }
        }
        int n2 = n;
        if (this.sortField != null) {
            n2 += 2;
        }
        if (arrayList != null) {
            n2 += 2;
        }
        if (this.forceExactQuery) {
            n2 += FORCED_DATA.length;
        }
        object = new byte[n2];
        int n3 = 0;
        if (this.sortField != null) {
            object[n3++] = 8;
            object[n3++] = this.sortField.value();
        }
        if (arrayList != null) {
            object[n3++] = 18;
            object[n3++] = (byte)n;
            for (SearchField searchField3 : arrayList) {
                System.arraycopy(searchField3.data(), 0, object, n3, searchField3.length());
                n3 += searchField3.length();
            }
        }
        if (this.forceExactQuery) {
            System.arraycopy(FORCED_DATA, 0, object, n3, FORCED_DATA.length);
        }
        String string = Base64Encoder.getInstance().encodeToString((byte[])object);
        return string.replace("=", "%253D");
    }

    public String query() {
        return this.query;
    }

    public RequestSearchResult forceExactQuery(boolean bl) {
        this.forceExactQuery = bl;
        return this;
    }

    public RequestSearchResult filter(SearchField ... searchFieldArray) {
        for (SearchField searchField : searchFieldArray) {
            this.filterFields.put(searchField.category(), searchField);
        }
        return this;
    }

    public RequestSearchResult uploadedThis(UploadDateField uploadDateField) {
        this.put(uploadDateField);
        return this;
    }

    public RequestSearchResult type(TypeField typeField) {
        this.put(typeField);
        return this;
    }

    public RequestSearchResult during(DurationField durationField) {
        this.put(durationField);
        return this;
    }

    public RequestSearchResult match(FeatureField ... featureFieldArray) {
        return this.filter(featureFieldArray);
    }

    public RequestSearchResult format(FormatField ... formatFieldArray) {
        return this.filter(formatFieldArray);
    }

    public RequestSearchResult sortBy(SortField sortField) {
        this.sortField = sortField;
        return this;
    }

    private void put(SearchField searchField) {
        this.filterFields.put(searchField.category(), searchField);
    }
}

